﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Audio;
using System.IO;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Content;

namespace CashierCrisis.Managers
{

    public static class AudioManager
    {
        private static Dictionary<string, SoundEffect> _soundEffects = new Dictionary<string,SoundEffect>();
        private static Dictionary<string, Song> _music = new Dictionary<string, Song>();

        public static SoundEffectInstance PlaySound(string soundName)
        {
           SoundEffectInstance sound = _soundEffects[soundName].Play();
           return sound;
        }

        public static Song PlayMusic(string musicName)
        {
            Song song = _music[musicName];
            MediaPlayer.Play(song);
            return song;
        }

        public static void LoadSoundContent(ContentManager content, string assetName, string audioName)
        {
            SoundEffect soundEffect = content.Load<SoundEffect>(assetName);

            if (string.IsNullOrEmpty(audioName))
            {
                _soundEffects.Add(assetName, soundEffect);
            }
            else
                _soundEffects.Add(audioName, soundEffect);
        }

        public static void LoadMusicContent(ContentManager content, string assetName, string audioName)
        {
            Song song = content.Load<Song>(assetName);

            if (string.IsNullOrEmpty(assetName))
            {
                _music.Add(assetName, song);
            }
            else
            {
                if(!_music.ContainsKey(audioName))
                    _music.Add(audioName, song);
            }
        }
    }


    public static class XactAudioManager
    {
        static AudioEngine audioEngine;
        static WaveBank waveBank;
        static SoundBank soundBank;

        public static void Init(string audioParameters, string waveFile, string soundBankFile)
        {
            audioEngine = new AudioEngine(audioParameters);
            waveBank = new WaveBank(audioEngine, waveFile);
            soundBank = new SoundBank(audioEngine, soundBankFile);
        }

        public static Cue PlaySound(string soundName)
        {
            Cue output = soundBank.GetCue(soundName);
            output.Play();
            return output;
        }

        public static void StopSound(Cue cue)
        {
            cue.Stop(AudioStopOptions.Immediate);
        }

    }
}
